<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Chart from XML</h1>
<div id="chartContainer"></div>

<script>
    window.onload = function () {
        var dataPoints = [];
        
        var chart = new CanvasJS.Chart("chartContainer",
        { 
            title:{
                text:	"Area of Continents"
            },
            data: [
            {
                type: "pie",
                indexLabel: "{label} : #percent%",
                toolTipContent : "{label}: {y} sq. km",
                dataPoints: dataPoints
            }					
            ]
        });
        
        $.get("../data/area-of-continents.xml", function (data) {
            $(data).find("point").each(function () {
                var $dataPoint = $(this);
                var label = $dataPoint.find("label").text();
                var y = $dataPoint.find("y").text();
                dataPoints.push({ label: label, y: parseFloat(y) });
        
            });
            chart.render();
        });
    }
</script>

<?php include '../footer.php'; ?>